package gov.va.med.mhv.usermgmt.form;

import java.util.Calendar;
import java.util.Date;

import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.util.CalendarUtils;
import org.tigris.atlas.validate.Validations;

/**
 * The DownloadYourDataForm class is responsible for handling user input.
 */
public class DownloadYourDataForm extends DownloadYourDataBaseForm {

	private static final long serialVersionUID = 1L;
	private String toDateRangeFieldLevelErrorMessage;
	private String fromDateRangeFieldLevelErrorMessage;
	private String executeJSKey = "executeJs";
	private String goalsall;
	private String appointmentsall;
	private String allergiesall;
	private String vitalsandreadingsall;
	private String healthhistoryall;
	private String foodactivityall;
	private String demohealthall;
	
	protected void doReset(ActionMapping mapping, HttpServletRequest request) {
		this.setFromDateDay(null);
		this.setFromDateMonth(null);
		this.setFromDateYear(null);
		this.setToDateDay(CalendarUtils.getCurrentDay());
		this.setToDateMonth(CalendarUtils.getCurrentMonth());
		this.setToDateYear(CalendarUtils.getCurrentYear());
		this.setPickDataClasses(null);
		this.setPickDate(null);
		this.setGoalsall("");
		this.setVitalsandreadingsall("");
		this.setHealthhistoryall("");
		this.setFoodactivityall("");
		this.setDemohealthall("");
		this.setAllergiesall("");
		this.setAppointmentsall("");
		fromDateRangeFieldLevelErrorMessage = "";
		toDateRangeFieldLevelErrorMessage = "";
	}

	public Date getToDate(){
		return CalendarUtils.getDate(getToDateMonth(), getToDateDay(), getToDateYear() );
	}

	public Date getFromDate(){
		return CalendarUtils.getDate(getFromDateMonth(), getFromDateDay(), getFromDateYear() );
	}

	public void setFromDate(Date newDate){
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(newDate);
		setFromDateMonth(""+(calendar.get(Calendar.MONTH)+1));
		setFromDateDay(""+calendar.get(Calendar.DAY_OF_MONTH));
		setFromDateYear(""+calendar.get(Calendar.YEAR));
	}

	public void setToDate(Date newDate){
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(newDate);
		setToDateMonth(""+(calendar.get(Calendar.MONTH)+1));
		setToDateDay(""+calendar.get(Calendar.DAY_OF_MONTH));
		setToDateYear(""+calendar.get(Calendar.YEAR));
	}

	protected void additionalValidation(HttpServletRequest request) {
		super.additionalValidation(request);
		if(!this.appointmentsall.equals("")) {
			if(this.appointmentsall.equals("true")) {
				setPastappointments("true");
				setFutureappointments("true");
			}
		}
		if(!this.allergiesall.equals("")) {
			if(this.allergiesall.equals("true")) {
				setVaallergies("true");
				setSeiallergies("true");
			}
		}
		if(!this.vitalsandreadingsall.equals("")) {
			if(this.vitalsandreadingsall.equals("true")) {
				setVitalsandreadings("true");
				setVahthvitals("true");
				setVavitals("true");
			}
		}
		if(!this.healthhistoryall.equals("")) {
			if(this.healthhistoryall.equals("true")) {
				setMedicalevents("true");
				setFamilyhealthhistory("true");
				setMilitaryhealthhistory("true");
				setTreatmentfacilities("true");
				setHealthcareproviders("true");
			}
		}
		if(!this.foodactivityall.equals("")) {
			if(this.foodactivityall.equals("true")) {
				setActivityjournal("true");
				setFoodjournal("true");
			}
		}
		if(!this.demohealthall.equals("")) {
			if(this.demohealthall.equals("true")) {
				setHealthinsurance("true");
				setVademographics("true");
			}
		}
		if("downloadSelectedDataClasses".equalsIgnoreCase(getPickDataClasses())){
			if(( getSeiallergies() == null || getSeiallergies().equalsIgnoreCase("false"))
				&& (getWellness() == null || getWellness().equalsIgnoreCase("false"))
				&& (getPastappointments() == null || getPastappointments().equalsIgnoreCase("false"))
				&& (getFutureappointments() == null || getFutureappointments().equalsIgnoreCase("false"))
				&& (getVitalsandreadings() == null || getVitalsandreadings().equalsIgnoreCase("false"))
				&& (getPrescriptions() == null || getPrescriptions().equalsIgnoreCase("false"))
				&& (getTreatmentfacilities() == null || getTreatmentfacilities().equalsIgnoreCase("false"))
				&& (getMilitaryhealthhistory() == null || getMilitaryhealthhistory().equalsIgnoreCase("false"))
				&& (getMedicalevents() == null || getMedicalevents().equalsIgnoreCase("false"))
				&& (getLabsandtests() == null || getLabsandtests().equalsIgnoreCase("false"))
				&& (getImmunizations() == null || getImmunizations().equalsIgnoreCase("false"))
				&& (getHealthinsurance() == null || getHealthinsurance().equalsIgnoreCase("false"))
				&& (getHealthcareproviders() == null || getHealthcareproviders().equalsIgnoreCase("false"))
				&& (getFamilyhealthhistory() == null || getFamilyhealthhistory().equalsIgnoreCase("false"))
				&& (getVaallergies() == null || getVaallergies().equalsIgnoreCase("false"))
				&& (getVachemlabs() == null || getVachemlabs().equalsIgnoreCase("false"))
				&& (getDodmilitaryservice() == null || getDodmilitaryservice().equalsIgnoreCase("false"))
				&& (getVaadmissionsanddischarges() == null || getVaadmissionsanddischarges().equalsIgnoreCase("false"))
				&& (getVaimmunizations() == null || getVaimmunizations().equalsIgnoreCase("false"))
				&& (getVaproblemlist() == null || getVaproblemlist().equalsIgnoreCase("false"))
				&& (getVaradiology() == null || getVaradiology().equalsIgnoreCase("false"))
				&& (getVavitals() == null || getVavitals().equalsIgnoreCase("false"))
				&& (getActivityjournal() == null || getActivityjournal().equalsIgnoreCase("false"))
				&& (getFoodjournal() == null || getFoodjournal().equalsIgnoreCase("false"))
				&& (getVademographics() == null || getVademographics().equalsIgnoreCase("false"))
				&& (getVamicrobiology() == null || getVamicrobiology().equalsIgnoreCase("false"))
				&& (getVapathology() == null || getVapathology().equalsIgnoreCase("false"))
				&& (getVapathologycytology() == null || getVapathologycytology().equalsIgnoreCase("false"))
				&& (getVapathologysurgicalpathology() == null || getVapathologysurgicalpathology().equalsIgnoreCase("false"))
				&& (getVapathologyelectronmicroscopy() == null || getVapathologyelectronmicroscopy().equalsIgnoreCase("false"))
				&& (getVaprogressnotes() == null || getVaprogressnotes().equalsIgnoreCase("false"))
				&& (getVahthvitals() == null || getVahthvitals().equalsIgnoreCase("false"))
				&& (getCompletedgoals() == null || getCompletedgoals().equalsIgnoreCase("false"))
				&& (getCurrentgoals() == null || getCurrentgoals().equalsIgnoreCase("false"))
				&& (getVaekg() == null || getVaekg().equalsIgnoreCase("false"))
				&& (getMedications() == null || getMedications().equalsIgnoreCase("false"))
				&& (getMedhistory() == null || getMedhistory().equalsIgnoreCase("false"))
				&& (getCurrentmedslist() == null || getCurrentmedslist().equalsIgnoreCase("false"))
				&& (getMedhistorynon() == null || getMedhistorynon().equalsIgnoreCase("false"))
				&& (getCurrentmedslistnon() == null || getCurrentmedslistnon().equalsIgnoreCase("false"))
			   ){

			   getMessages().addMessage(MessageUtils.createErrorMessage(
					   UserManagementMessages.BLUEBUTTON_INVALID_SEARCH_CRITERIA_1,null,null));
			   getMessages().addMessage(MessageUtils.createErrorMessage(
					   UserManagementMessages.BLUEBUTTON_INVALID_SEARCH_CRITERIA_2,null,null));
			}
		}

		Validations.validateDate(getToDateMonth(), getToDateDay(), getToDateYear(), "toDate", "To Date", true, getMessages());
	    Validations.validateDate(getFromDateMonth(), getFromDateDay(), getFromDateYear(), "fromDate", "From Date", true, getMessages());

	    if(!getMessages().hasErrorMessages()){
			Date fromDate =  getFromDate();
			Date toDate =  getToDate();

			Calendar oneMonthFromToDate = Calendar.getInstance();
			oneMonthFromToDate.setTime(toDate);
			oneMonthFromToDate.add(Calendar.MONTH, -1);

			if(fromDate.compareTo(toDate)>0){
				Message errMsg = MessageUtils.createErrorMessage("bb.error.from.greater", new String[]{"fromDate"}, null);
				// CR 7269: Retain user input
				if("downloadAllDataClasses".equalsIgnoreCase(getPickDataClasses())){
					request.getSession().setAttribute(executeJSKey,true);
				}
				getMessages().addMessage(errMsg);
			}
	    }
		setFieldLevelErrorMessages(getMessages(), request);
		setMyFieldLevelErrorMessages(getMessages(), request);
	}

	private void setMyFieldLevelErrorMessages(Messages messages, HttpServletRequest request) {
		if (getMessages().getErrorMessageCount("fromDate") > 0) {
			Message message = (Message) messages.getErrorMessages("fromDate").iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			fromDateRangeFieldLevelErrorMessage = errorString;
		}
		if (getMessages().getErrorMessageCount("toDate") > 0) {
			Message message = (Message) messages.getErrorMessages("toDate").iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			toDateRangeFieldLevelErrorMessage = errorString;
		}
	}

	public String getFromDateRangeErrorMessage() {
		return fromDateRangeFieldLevelErrorMessage;
	}

	public String getToDateRangeErrorMessage() {
		return toDateRangeFieldLevelErrorMessage;
	}

	public void setGoalsall(String value) {
		this.goalsall = value;
		setCompletedgoals(value);
		setCurrentgoals(value);
	}
	
	public String getGoalsall() {
		return goalsall;
	}
	
	public String getAppointmentsall() {
		return appointmentsall;
	}
	
	public void setAppointmentsall(String value) {
		this.appointmentsall = value;
		setFutureappointments(value);
		setPastappointments(value);
	}
	
	public String getAllergiesall() {
		return allergiesall;
	}
	
	public void setAllergiesall(String value) {
		this.allergiesall = value;
		setVaallergies(value);
		setSeiallergies(value);
	}
	
	public String getVitalsandreadingsall() {
		return vitalsandreadingsall;
	}
	
	public void setVitalsandreadingsall(String value) {
		this.vitalsandreadingsall = value;
		setVitalsandreadings(value);
		setVahthvitals(value);
		setVavitals(value);
	}
	
	public String getHealthhistoryall() {
		return healthhistoryall;
	}
	
	public void setHealthhistoryall(String value) {
		this.healthhistoryall = value;
		setMedicalevents(value);
		setFamilyhealthhistory(value);
		setMilitaryhealthhistory(value);
		setTreatmentfacilities(value);
		setHealthcareproviders(value);
	}
	
	public String getFoodactivityall() {
		return foodactivityall;
	}
	
	public void setFoodactivityall(String value) {
		this.foodactivityall = value;
		setActivityjournal(value);
		setFoodjournal(value);
	}
	
	public String getDemohealthall() {
		return demohealthall;
	}
	
	public void setDemohealthall(String value) {
		this.demohealthall = value;
		setHealthinsurance(value);
		setVademographics(value);
	}
}